// Cloned Settings buttons
const originalContainer = document.querySelector(
  "#settings .cuisine-container"
);
const originalButton = document.querySelector(
  "#settings .cuisine-container button"
);

originalButton.addEventListener("click", () => {
  const button_switch = originalButton.querySelector("img");

  if (originalButton.classList.contains("enabled")) {
    originalButton.classList.replace("enabled", "disabled");
    button_switch.src = "./assets/icons/toggle-off.svg";
  } else if (originalButton.classList.contains("disabled")) {
    originalButton.classList.replace("disabled", "enabled");
    button_switch.src = "./assets/icons/toggle-on.svg";
  }
});

const cuisines = [
  "Afghan",
  "African",
  "American",
  "Argentine",
  "Armenian",
  "Australian",
  "Austrian",
  "Balkan",
  "Bangladeshi",
  "Barbadian",
  "Belgian",
  "Brazilian",
  "British",
  "Bulgarian",
  "Cajun",
  "Cambodian",
  "Canadian",
  "Caribbean",
  "Catalan",
  "Chinese",
  "Colombian",
  "Cuban",
  "Cypriot",
  "Czech",
  "Danish",
  "Egyptian",
  "Ethiopian",
  "Filipino",
  "Finnish",
  "French",
  "Georgian",
  "German",
  "Ghanaian",
  "Greek",
  "Guatemalan",
  "Haitian",
  "Honduran",
  "Hungarian",
  "Indian",
  "Indonesian",
  "Irish",
  "Italian",
  "Jamaican",
  "Japanese",
  "Jordanian",
  "Kenyan",
  "Korean",
  "Lebanese",
  "Malaysian",
  "Mexican",
  "Moroccan",
  "Nepalese",
  "Nigerian",
  "Norwegian",
  "Pakistani",
  "Peruvian",
  "Polish",
  "Portuguese",
  "Puerto Rican",
  "Romanian",
  "Russian",
  "Samoan",
  "Saudi Arabian",
  "Scottish",
  "Singaporean",
];

const settingsData = []

// Loop to create 50 duplicates
for (let i = 1; i < 60; i++) {
  const clonedButton = originalButton.cloneNode(true);
  clonedButton.id = `button-${i + 1}`;
  const button_switch = clonedButton.querySelector("img");
  const button_text = clonedButton.querySelector(".button-text");
  button_text.textContent = cuisines[i];

  businessProfile.otherSettings.cuisines.forEach((cuisine) => {
    if (cuisines[i].toLowerCase() == cuisine.toLowerCase()) {
      clonedButton.classList.replace("disabled", "enabled");
      button_switch.src = "./assets/icons/toggle-on.svg";
    }
  });

  clonedButton.addEventListener("click", () => {
    if (clonedButton.classList.contains("enabled")) {
      clonedButton.classList.replace("enabled", "disabled");
      button_switch.src = "./assets/icons/toggle-off.svg";
    } else if (clonedButton.classList.contains("disabled")) {
      clonedButton.classList.replace("disabled", "enabled");
      button_switch.src = "./assets/icons/toggle-on.svg";
    }
  });

  originalContainer.appendChild(clonedButton);
}

// Setting up settings navigation
const settingsHeaderNavItems = document.querySelectorAll(
  "#settings .settings-header .pagination:first-child li"
);
const settingsSubSections = document.querySelectorAll(
  "#settings .settings-body > div"
);

settingsHeaderNavItems.forEach((item, index) => {
  item.addEventListener("click", () => {
    clearShowClass(settingsSubSections);
    settingsSubSections[index].classList.add("show");
    settingsHeaderNavItems.forEach((item) => {
      item.classList.remove("active");
    });
    item.classList.add("active");
  });
});

const settingsMobileNavItems = document.querySelectorAll(
  "#settings .settings-header .pagination.mobile li"
);
settingsMobileNavItems.forEach((item, index) => {
  item.addEventListener("click", () => {
    clearShowClass(settingsSubSections);
    settingsSubSections[index].classList.add("show");
    settingsMobileNavItems.forEach((item) => {
      item.classList.remove("active");
    });
    item.classList.add("active");
  });
});

const settingPublishBtns = document.querySelectorAll("#settings .publish-button")
const settings = document.querySelector("#settings")
settingPublishBtns.forEach((button) => {
    button.addEventListener("click", ()=>{
      const deliveryFoodPreparationTime = settings.querySelector("");
      const deliveryMinOrderPrice = settings.querySelector("");
      const deliveryDeliveryDistance = settings.querySelector("");
      const dineinMinOrderPrice = settings.querySelector("");
      const dininTables = settings.querySelector("");
      const takeawayMinOrderPrice = settings.querySelector("");
      const morningOpeningHour = settings.querySelector("");
      const morningClosingTime = settings.querySelector("");
      const EveningClosingTime = settings.querySelector("");
      const taxPercentage = settings.querySelector("");
      const taxStatus = settings.querySelector("");
      const platformFee = settings.querySelector("");
      // const deliveryFoodPreparationTime = settings.querySelector("");
      // const deliveryFoodPreparationTime = settings.querySelector("");
      // const deliveryFoodPreparationTime = settings.querySelector("");
    })
})
var map2 = L.map("map2", {
  zoomControl: false,
  attributionControl: false,
}).setView([48.85, 2.35], 10);

var myIcon2 = L.icon({
  iconUrl: "./assets/images/map-icon.png",
  iconSize: [60, 60],
  iconAnchor: [20, 40],
});

var map2Marker = L.marker([50.505, 30.57], {
  icon: myIcon2,
  draggable: true,
}).addTo(map2);

map2Marker.on("dragend", function () {
  var position = map2Marker.getLatLng();
  map2Marker.setLatLng(position);
});

var group2 = L.featureGroup([map2Marker]).addTo(map2);

setTimeout(function () {
  if (group2.getBounds()) {
    map2.fitBounds(group2.getBounds());
  }
}, 1000);

if (map2.zoomControl) {
  map2.removeControl(map2.zoomControl);
}

var googleStreets2 = L.tileLayer(
  "https://{s}.google.com/vt/lyrs=m&x={x}&y={y}&z={z}",
  {
    maxZoom: 12,
    subdomains: ["mt0", "mt1", "mt2", "mt3"],
  }
);

googleStreets2.addTo(map2);

// Refresh map size
function refreshMap() {
  setTimeout(() => {
    map2.invalidateSize(true);
  }, 100);
}

// Listen for tab navigation or visibility change
const linkButtons = document.querySelectorAll(".navigation-container2 ul li a");

linkButtons[7].addEventListener("click", () => {
  settingsHeaderNavItems[3].addEventListener("click", () => {
    refreshMap();
  });
});
