const reviews = document.querySelector("#review");
const reviewListItems = document.querySelectorAll(".review-card");
reviewListItems.forEach((item) => {
  const commentBoxToggles = item.querySelectorAll(
    ".review p.title button, .review .reply-button"
  );
  commentBoxToggles.forEach((toggle) => {
    toggle.addEventListener("click", () => {
      if (item.classList.contains("open")) {
        item.classList.remove("open");
      } else {
        item.classList.add("open");
      }
    });
  });
  const closeButton = item.querySelector(" .close-button");
  closeButton.addEventListener("click", () => {
    item.classList.remove("open");
  });
  const commentBox = item.querySelector(".comment-box");
  const editCommentButton = commentBox.querySelector(".comment .edit");
  const cancelEditButtons = item.querySelectorAll(
    ".comment-box .comment .cancel-button, .comment-box .comment .comment-input button"
  );
  const textarea = commentBox.querySelector("textarea");

  editCommentButton.addEventListener("click", () => {
    commentBox.classList.add("edit");
    textarea.style.height = "auto";
    textarea.style.height = `${textarea.scrollHeight}px`;
  });
  cancelEditButtons.forEach((button) => {
    button.addEventListener("click", () => {
      commentBox.classList.remove("edit");
    });
  });
});
