// Create a single function for handling image processing results
const handleImageResult = (editedData, currentEditor) => {
    return new Promise((resolve, reject) => {
      const uploadImageModal = document.querySelector("#upload-image-modal");
      const cropPhotoModal = document.querySelector("#crop-modal");
      uploadImageModal.showModal();
  
      const replaceImageBtn = uploadImageModal.querySelector("#photo-replace-btn");
      const publishButton = uploadImageModal.querySelector(".done-button");
  
      const cleanup = () => {
        uploadImageModal.close();
        cropPhotoModal.close();
        publishButton.removeEventListener('click', handlePublish);
        replaceImageBtn.removeEventListener('click', handleReplace);
      };
  
      const handlePublish = () => {
        cleanup();
        currentEditor.destroy();
        resolve({
          success: true,
          url: editedData.url,
          file: editedData.file
        });
      };
  
      const handleReplace = () => {
        cleanup();
        currentEditor.destroy();
        
        // Create new editor instance
        const newEditor = new ImageEdit({
          inputFieldId: "male-image-input",
          editModalId: "crop-modal",
          onEdit: async (newEditedData) => {
            try {
              // Pass the new editor instance to handle result
              const result = await handleImageResult(newEditedData, newEditor);
              return result; // This will propagate back to the original caller
            } catch (error) {
              console.error("Upload failed or was cancelled:", error);
            }
          },
        });
  
        // Trigger the file input
        const newInput = document.getElementById("male-image-input");
        if (newInput) {
          newInput.click();
        }
      };
  
      publishButton.addEventListener('click', handlePublish);
      replaceImageBtn.addEventListener('click', handleReplace);
    });
  };
  
  // Initial editor setup
  const imageEditor = new ImageEdit({
    inputFieldId: "male-image-input",
    editModalId: "crop-modal",
    onEdit: async (editedData) => {
      try {
        // Use the shared result handler
        const result = await handleImageResult(editedData, imageEditor);
        // Handle the result however you need
        profilePhoto.src = result.url;
        // Other buttons can use the same handleImageResult function
        // and handle their own results
      } catch (error) {
        console.error("Upload failed or was cancelled:", error);
      }
    },
  });
  
  // Example of another button using the same handler
  someOtherButton.addEventListener('click', async () => {
    const result = await handleImageResult(someData, someEditor);
    // Handle result differently here
    differentPhoto.src = result.url;
  });