const discountPage = document.querySelector("#discount");
const dailyDiscountSection = discountPage.querySelector(".daily-discount");
const deliveryDiscountSection =
  discountPage.querySelector(".delivery-discount");
const discountButtonContainer = discountPage.querySelector(
  ".discount-header .swap-button"
);

discountButtonContainer.addEventListener("click", (event) => {
  const rect = discountButtonContainer.getBoundingClientRect();
  const clickX = event.clientX;

  const isLeftClick = clickX < rect.left + rect.width / 2;
  const titleSpan = document.getElementById("page-title");

  if (isLeftClick) {
    discountButtonContainer.classList.remove("right-clicked");
    discountButtonContainer.classList.add("left-clicked");

    dailyDiscountSection.classList.add("show");
    deliveryDiscountSection.classList.remove("show");

    titleSpan.innerHTML = "Discount &nbsp; > &nbsp; Daily Discount";
  } else {
    discountButtonContainer.classList.remove("left-clicked");
    discountButtonContainer.classList.add("right-clicked");

    deliveryDiscountSection.classList.add("show");
    dailyDiscountSection.classList.remove("show");

    titleSpan.innerHTML = "Discount &nbsp; > &nbsp; Delivery Fee Discount";
  }
});

function updateTitle() {
  const titleSpan = document.getElementById("page-title");
  if (dailyDiscountSection.classList.contains("show")) {
    titleSpan.innerHTML = "Discount &nbsp; > &nbsp; Daily Discount";
  } else if (deliveryDiscountSection.classList.contains("show")) {
    titleSpan.innerHTML = "Discount &nbsp; > &nbsp; Delivery Fee Discount";
  }
}

// Manage pagination style
const discountPageButtons = document.querySelectorAll(
  ".daily-discount .pagination-container li"
);
discountPageButtons.forEach((button) => {
  button.addEventListener("click", () => {
    discountPageButtons.forEach((item) => {
      item.classList.remove("active");
    });
    button.classList.add("active");
  });
});

const paginationButtons = discountPage.querySelectorAll(
  ".pagination-container li button"
);
paginationButtons.forEach((button) => {
  button.addEventListener("click", () => {
    const sectionId = button.getAttribute("data-target").split("#")[1];
    scrollToSection(sectionId);
  });
});

const discountForms = discountPage.querySelectorAll(".discount-forms form");

// Manage scroll behaviour
function scrollToSection(sectionId) {
  const headerHeight = 200;
  const target = document.querySelector(`#${sectionId}`);

  if (!target) {
    return;
  }

  const targetPosition = target.offsetTop;
  if (targetPosition < 0) {
    return;
  }

  const discountPageForms = discountPage.querySelector(".discount-forms");
  discountPageForms.scrollTo({
    top: targetPosition - headerHeight,
    behavior: "smooth",
  });
}

// Manage pagination for mobile view
const deliveryDiscountPageMobileBtn = document.querySelector(
  ".daily-discount .pagination-container2 li:nth-child(1)"
);
const dineinDiscountPageMobileBtn = document.querySelector(
  ".daily-discount .pagination-container2 li:nth-child(2)"
);
const takeawayDiscountPageMobileBtn = document.querySelector(
  ".daily-discount .pagination-container2 li:nth-child(3)"
);

const deliveryDiscountForm = document.querySelector(".delivery-form");
const dineinDiscountForm = document.querySelector(".dinein-form");
const takeawayDiscountForm = document.querySelector(".takeaway-form");

deliveryDiscountPageMobileBtn.addEventListener("click", () => {
  deliveryDiscountForm.classList.add("show");
});
dineinDiscountPageMobileBtn.addEventListener("click", () => {
  dineinDiscountForm.classList.add("show");
});
takeawayDiscountPageMobileBtn.addEventListener("click", () => {
  takeawayDiscountForm.classList.add("show");
});
discountForms.forEach((form) => {
  const formCloseBtn = form.querySelector(".form-header .close-btn");
  formCloseBtn.addEventListener("click", () => {
    form.classList.remove("show");
  });
});

// Handle form input and style
const discountDays = discountPage.querySelectorAll(".form-group .form-row");

discountDays.forEach((day) => {
  const dayElement = day.querySelector(".day");

  dayElement.addEventListener("click", () => {
    day.classList.toggle("active");
  });
  const timeDropdown = day.querySelector(".floating-controls.dropdown");
  const percentageDiscount = day.querySelector(
    ".floating-controls input.percentage-discount"
  );
  const minOrder = day.querySelector(".floating-controls input.min-order");

  const checkForActiveClass = () => {
    const hasValue = (input) => input && input.value.trim() !== "";
    const dropdownSelected =
      timeDropdown && timeDropdown.classList.contains("selected");

    if (
      hasValue(percentageDiscount) ||
      hasValue(minOrder) ||
      dropdownSelected
    ) {
      day.classList.add("active");
    } else {
      day.classList.remove("active");
    }
  };

  checkForActiveClass();

  if (percentageDiscount) {
    percentageDiscount.addEventListener("input", checkForActiveClass);
  }
  if (minOrder) {
    minOrder.addEventListener("input", checkForActiveClass);
  }

  if (timeDropdown) {
    const dropdownItems = timeDropdown.querySelectorAll("li");

    dropdownItems.forEach((item) => {
      item.addEventListener("click", () => {
        timeDropdown.classList.add("selected");
        checkForActiveClass();
      });
    });
  }
});

const allDiscountForms = document.querySelectorAll("#discount form");

allDiscountForms.forEach((form, index) => {
  const discountUpdateButtons = form.querySelectorAll(".update-button");

  discountUpdateButtons.forEach((button) => {
    button.addEventListener("click", () => {
      const modal = existingModal.cloneNode(true);
      modal.id = "update-discount-modal";
      modal.classList.add("confirm-modal", "lined-modal");

      modal.innerHTML = `
              <div class="modal-heading">
                <p>
                  <svg width="18" height="18" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M15.875 11C15.875 11.2984 15.7565 11.5845 15.5455 11.7955C15.3345 12.0065 15.0484 12.125 14.75 12.125H7.25C6.95164 12.125 6.66549 12.0065 6.45451 11.7955C6.24353 11.5845 6.125 11.2984 6.125 11C6.125 10.7016 6.24353 10.4155 6.45451 10.2045C6.66549 9.99353 6.95164 9.875 7.25 9.875H14.75C15.0484 9.875 15.3345 9.99353 15.5455 10.2045C15.7565 10.4155 15.875 10.7016 15.875 11ZM21.125 11C21.125 13.0025 20.5312 14.9601 19.4186 16.6251C18.3061 18.2902 16.7248 19.5879 14.8747 20.3543C13.0246 21.1206 10.9888 21.3211 9.02471 20.9305C7.06066 20.5398 5.25656 19.5755 3.84055 18.1595C2.42454 16.7435 1.46023 14.9393 1.06955 12.9753C0.678878 11.0112 0.879387 8.97543 1.64572 7.12533C2.41206 5.27523 3.70981 3.69392 5.37486 2.58137C7.0399 1.46882 8.99747 0.875 11 0.875C13.6844 0.877978 16.258 1.94567 18.1562 3.84383C20.0543 5.74199 21.122 8.3156 21.125 11ZM18.875 11C18.875 9.44247 18.4131 7.91992 17.5478 6.62488C16.6825 5.32985 15.4526 4.32049 14.0136 3.72445C12.5747 3.12841 10.9913 2.97246 9.46367 3.27632C7.93607 3.58017 6.53288 4.3302 5.43154 5.43153C4.3302 6.53287 3.58018 7.93606 3.27632 9.46366C2.97246 10.9913 3.12841 12.5747 3.72445 14.0136C4.32049 15.4526 5.32985 16.6825 6.62489 17.5478C7.91993 18.4131 9.44248 18.875 11 18.875C13.0879 18.8728 15.0896 18.0424 16.566 16.566C18.0424 15.0896 18.8728 13.0879 18.875 11Z" fill="#2D2C2C"/>
                  </svg>
                  <span>Discount</span>
                </p>
              </div>
              <div class="modal-body">
                <span>Yeah !👊🏾</span>
                <h2>Discount will be applied to selected days</h2>
                <div>
                  <svg width="35" height="35" viewBox="0 0 24 25" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M19.9173 10.5444L13.8057 12.9894L18.1379 18.5591C18.2293 18.6756 18.2969 18.809 18.3366 18.9517C18.3763 19.0944 18.3875 19.2435 18.3694 19.3905C18.3514 19.5375 18.3045 19.6795 18.2315 19.8083C18.1584 19.9372 18.0606 20.0503 17.9438 20.1413C17.8269 20.2323 17.6932 20.2992 17.5503 20.3384C17.4075 20.3776 17.2583 20.3882 17.1114 20.3696C16.9645 20.3509 16.8227 20.3035 16.6941 20.2299C16.5656 20.1564 16.4528 20.0582 16.3623 19.9409L12.0001 14.3328L7.63792 19.9409C7.45423 20.1751 7.18523 20.3269 6.88984 20.3632C6.59445 20.3994 6.29673 20.3171 6.06187 20.1343C5.82701 19.9516 5.67414 19.6832 5.63673 19.3879C5.59933 19.0927 5.68044 18.7946 5.8623 18.5591L10.1945 12.9894L4.08292 10.5444C3.94301 10.4915 3.81504 10.4113 3.7065 10.3084C3.59796 10.2055 3.51103 10.082 3.45078 9.94513C3.39053 9.80824 3.35819 9.66071 3.35563 9.51118C3.35308 9.36164 3.38037 9.21309 3.4359 9.07422C3.49143 8.93536 3.5741 8.80896 3.67906 8.70242C3.78403 8.59588 3.90918 8.51133 4.0472 8.45373C4.18523 8.39614 4.33335 8.36664 4.48291 8.36696C4.63247 8.36729 4.78046 8.39743 4.91824 8.45563L10.8751 10.8388V4.25C10.8751 3.95163 10.9936 3.66548 11.2046 3.4545C11.4156 3.24353 11.7017 3.125 12.0001 3.125C12.2985 3.125 12.5846 3.24353 12.7956 3.4545C13.0066 3.66548 13.1251 3.95163 13.1251 4.25V10.8388L19.082 8.45563C19.2198 8.39743 19.3678 8.36729 19.5173 8.36696C19.6669 8.36664 19.815 8.39614 19.953 8.45373C20.091 8.51133 20.2162 8.59588 20.3212 8.70242C20.4261 8.80896 20.5088 8.93536 20.5643 9.07422C20.6199 9.21309 20.6471 9.36164 20.6446 9.51118C20.642 9.66071 20.6097 9.80824 20.5494 9.94513C20.4892 10.082 20.4023 10.2055 20.2937 10.3084C20.1852 10.4113 20.0572 10.4915 19.9173 10.5444Z" fill="white"/>
                  </svg>
                  <p>
                    50% Total Discount of Delivery Order applied to Mon, Wed, and Friday.
                  </p>
                </div>
                <p class="button-section">
                  <button id="confirm-apply">
                    Apply
                  </button>
                  <button id="cancel-button">Cancel</button>
                </p>
              </div>
            `;
      main.appendChild(modal);

      modal.showModal();

      const cancelButton = modal.querySelector("#cancel-button");
      cancelButton.addEventListener("click", () => {
        modal.close();
        modal.remove();
      });

      const applyButton = modal.querySelector("#confirm-apply");
      applyButton.addEventListener("click", async () => {
        const clearForm = (form) => {
          const discountDays = form.querySelectorAll(".form-group .form-row");
          discountDays.forEach((day) => {
            const timeDropdown = day.querySelector(
              ".floating-controls.dropdown"
            );
            const percentageDiscount = day.querySelector(
              ".floating-controls input.percentage-discount"
            );
            const minOrder = day.querySelector(
              ".floating-controls input.min-order"
            );

            percentageDiscount.value = "";
            minOrder.value = "";
            timeDropdown.classList.remove("selected");
            day.classList.remove("active");

            const timeDropdownButton = timeDropdown.querySelector("button");
            timeDropdownButton.textContent = "";
          });
        };

        const formContainer = form.querySelector(".form-group")

        const formData = collectFormData(formContainer, index + 1);

        if (index == 0) {
          restaurantData.discount.dailyDiscount.deliveryOrderDiscount =
            formData;
        } else if (index == 1) {
          restaurantData.discount.dailyDiscount.dineinOrderDiscount = formData;
        } else if (index == 2) {
          restaurantData.discount.dailyDiscount.takeawayOrderDiscount =
            formData;
        } else if (index == 3) {
          restaurantData.discount.deliveryFeeDiscount = formData;
        }

        try {
          await update("restaurants", restaurantID, {
            discounts: restaurantData.discounts,
          });
          createAlert(
            "discount applied",
            "./assets/icons/send-icon.svg",
            "green-4"
          );
  
          setTimeout(() => {
            modal.close();
            modal.remove();
          }, 500);
        } catch (error) {
          createAlert(
            "Couldn't update discount",
            "./assets/icons/bin.svg",
            "red-5"
          );
        }
      });
    });
  });
});

const collectFormData = (formContainer, id) => {
  const days = [
    "monday",
    "tuesday",
    "wednesday",
    "thursday",
    "friday",
    "saturday",
    "sunday",
  ];
  const formData = {};

  days.forEach((day, index) => {
    const dayLower = day.toLowerCase();
    const dayData = {};

    const timeDropdown = formContainer.querySelector(
      `.form-row:nth-child(${index + 1}) .dropdown button`
    );
    if (
      timeDropdown.textContent &&
      timeDropdown.textContent !== "Select Time"
    ) {
      dayData.time = timeDropdown.textContent;
    }

    const percentageInput = formContainer.querySelector(
      `#${dayLower}-percentage-discount${id}`
    );
    if (percentageInput.value) {
      dayData.percentageDiscount = percentageInput.value;
    }

    const minOrderInput = formContainer.querySelector(
      `#${dayLower}-min-order${id}`
    );
    if (minOrderInput.value) {
      dayData.minOrder = minOrderInput.value;
    }

    if (Object.keys(dayData).length > 0) {
      formData[day] = dayData;
    }
  });

  return formData;
};
