const deliveryPartnerPage = document.querySelector("#delivery");
const deliveryPartners = [
  {
    id: "ZP37646739299399",
    name: "Jackson Henry",
    distance: "1km away",
    phone: "+1 894 747 44",
    email: "jacksonhenry@gmail.com",
    avatar: "./assets/icons/avatars/avatar-1.svg",
    totalEarnings: "$58,000.84",
    completedOrders: 124,
    averageDeliveriesPerDay: 24,
    averageDeliveries: 24,
    otherDeliveries: 12,
    lastDelivery: "1 hour ago",
    blockStatus: false,
    status: "Available",
    pinned: false,
    reviews: {
      totalReviews: 32,
      averageRating: 4.5,
      reviewsList: [
        {
          name: "Lisa Jackson",
          id: "ZP37646739299399",
          avatar: "./assets/icons/avatars/avatar-1.svg",
          reviewText:
            "Date night pics - we usually try to make reservations here ahead of time but can usually get a table on a mid weeknight early on in the evening. Love the seasonal specials here and all the sushi. Negitoro rolls are a staple in our rotation and their nigiri specials. I also really love that this restaurant, while very small with limited space, is kid friendly. I have dined here with 1 and then both of my kids and the staff are very kind and welcoming. They have high chairs. Food comes out quickly and the tables turn over relatively quickly with a few exceptions for tables that are drinking with more nibbles. Haven't had a bad meal here but the prices are definitely on the high side. Often wonder how the college students afford to eat here because I definitely didn't have the budget when I was in undergrad.",
          rating: 4.5,
          date: "3 days ago",
        },
        {
          name: "Lisa Jackson",
          id: "ZP37646739299399",
          avatar: "./assets/icons/avatars/avatar-1.svg",
          reviewText:
            "Date night pics - we usually try to make reservations here ahead of time but can usually get a table on a mid weeknight early on in the evening. Love the seasonal specials here and all the sushi. Negitoro rolls are a staple in our rotation and their nigiri specials. I also really love that this restaurant, while very small with limited space, is kid friendly. I have dined here with 1 and then both of my kids and the staff are very kind and welcoming. They have high chairs. Food comes out quickly and the tables turn over relatively quickly with a few exceptions for tables that are drinking with more nibbles. Haven't had a bad meal here but the prices are definitely on the high side. Often wonder how the college students afford to eat here because I definitely didn't have the budget when I was in undergrad.",
          rating: 4.5,
          date: "3 days ago",
        },
        {
          name: "Lisa Jackson",
          id: "ZP37646739299399",
          avatar: "./assets/icons/avatars/avatar-1.svg",
          reviewText:
            "Date night pics - we usually try to make reservations here ahead of time but can usually get a table on a mid weeknight early on in the evening. Love the seasonal specials here and all the sushi. Negitoro rolls are a staple in our rotation and their nigiri specials. I also really love that this restaurant, while very small with limited space, is kid friendly. I have dined here with 1 and then both of my kids and the staff are very kind and welcoming. They have high chairs. Food comes out quickly and the tables turn over relatively quickly with a few exceptions for tables that are drinking with more nibbles. Haven't had a bad meal here but the prices are definitely on the high side. Often wonder how the college students afford to eat here because I definitely didn't have the budget when I was in undergrad.",
          rating: 4.5,
          date: "3 days ago",
        },
        {
          name: "Lisa Jackson",
          id: "ZP37646739299399",
          avatar: "./assets/icons/avatars/avatar-1.svg",
          reviewText:
            "Date night pics - we usually try to make reservations here ahead of time but can usually get a table on a mid weeknight early on in the evening. Love the seasonal specials here and all the sushi. Negitoro rolls are a staple in our rotation and their nigiri specials. I also really love that this restaurant, while very small with limited space, is kid friendly. I have dined here with 1 and then both of my kids and the staff are very kind and welcoming. They have high chairs. Food comes out quickly and the tables turn over relatively quickly with a few exceptions for tables that are drinking with more nibbles. Haven't had a bad meal here but the prices are definitely on the high side. Often wonder how the college students afford to eat here because I definitely didn't have the budget when I was in undergrad.",
          rating: 4.5,
          date: "3 days ago",
        },
      ],
    },
  },
  {
    id: "ZP36746739245399",
    name: "Lily Donald",
    distance: "5km away",
    phone: "+1 894 747 44",
    email: "lilydonald@gmail.com",
    avatar: "./assets/icons/avatars/avatar-2.svg",
    totalEarnings: "$122,000.84",
    completedOrders: 220,
    averageDeliveriesPerDay: 32,
    averageDeliveries: 120,
    otherDeliveries: 100,
    lastDelivery: "30 minutes ago",
    blockStatus: false,
    status: "Unavailable",
    pinned: false,
    reviews: {
      totalReviews: 58,
      averageRating: 5,
      reviewsList: [
        {
          name: "Lisa Jackson",
          id: "ZP37646739299399",
          avatar: "./assets/icons/avatars/avatar-1.svg",
          reviewText:
            "Date night pics - we usually try to make reservations here ahead of time but can usually get a table on a mid weeknight early on in the evening. Love the seasonal specials here and all the sushi. Negitoro rolls are a staple in our rotation and their nigiri specials. I also really love that this restaurant, while very small with limited space, is kid friendly. I have dined here with 1 and then both of my kids and the staff are very kind and welcoming. They have high chairs. Food comes out quickly and the tables turn over relatively quickly with a few exceptions for tables that are drinking with more nibbles. Haven't had a bad meal here but the prices are definitely on the high side. Often wonder how the college students afford to eat here because I definitely didn't have the budget when I was in undergrad.",
          rating: 4.5,
          date: "3 days ago",
        },
        {
          name: "Lisa Jackson",
          id: "ZP37646739299399",
          avatar: "./assets/icons/avatars/avatar-1.svg",
          reviewText:
            "Date night pics - we usually try to make reservations here ahead of time but can usually get a table on a mid weeknight early on in the evening. Love the seasonal specials here and all the sushi. Negitoro rolls are a staple in our rotation and their nigiri specials. I also really love that this restaurant, while very small with limited space, is kid friendly. I have dined here with 1 and then both of my kids and the staff are very kind and welcoming. They have high chairs. Food comes out quickly and the tables turn over relatively quickly with a few exceptions for tables that are drinking with more nibbles. Haven't had a bad meal here but the prices are definitely on the high side. Often wonder how the college students afford to eat here because I definitely didn't have the budget when I was in undergrad.",
          rating: 4.5,
          date: "3 days ago",
        },
        {
          name: "Lisa Jackson",
          id: "ZP37646739299399",
          avatar: "./assets/icons/avatars/avatar-1.svg",
          reviewText:
            "Date night pics - we usually try to make reservations here ahead of time but can usually get a table on a mid weeknight early on in the evening. Love the seasonal specials here and all the sushi. Negitoro rolls are a staple in our rotation and their nigiri specials. I also really love that this restaurant, while very small with limited space, is kid friendly. I have dined here with 1 and then both of my kids and the staff are very kind and welcoming. They have high chairs. Food comes out quickly and the tables turn over relatively quickly with a few exceptions for tables that are drinking with more nibbles. Haven't had a bad meal here but the prices are definitely on the high side. Often wonder how the college students afford to eat here because I definitely didn't have the budget when I was in undergrad.",
          rating: 4.5,
          date: "3 days ago",
        },
        {
          name: "Lisa Jackson",
          id: "ZP37646739299399",
          avatar: "./assets/icons/avatars/avatar-1.svg",
          reviewText:
            "Date night pics - we usually try to make reservations here ahead of time but can usually get a table on a mid weeknight early on in the evening. Love the seasonal specials here and all the sushi. Negitoro rolls are a staple in our rotation and their nigiri specials. I also really love that this restaurant, while very small with limited space, is kid friendly. I have dined here with 1 and then both of my kids and the staff are very kind and welcoming. They have high chairs. Food comes out quickly and the tables turn over relatively quickly with a few exceptions for tables that are drinking with more nibbles. Haven't had a bad meal here but the prices are definitely on the high side. Often wonder how the college students afford to eat here because I definitely didn't have the budget when I was in undergrad.",
          rating: 4.5,
          date: "3 days ago",
        },
      ],
    },
  },
  {
    id: "ZP3762222299399",
    name: "John Doe",
    distance: "1km away",
    phone: "+1 894 747 44",
    email: "johndoe@gmail.com",
    avatar: "./assets/icons/avatars/avatar-3.svg",
    totalEarnings: "$48,000.84",
    completedOrders: 104,
    averageDeliveriesPerDay: 16,
    averageDeliveries: 24,
    otherDeliveries: 16,
    lastDelivery: "2 hours ago",
    blockStatus: false,
    status: "Unavailable",
    pinned: true,
    reviews: {
      totalReviews: 18,
      averageRating: 4.3,
      reviewsList: [
        {
          name: "Lisa Jackson",
          id: "ZP37646739299399",
          avatar: "./assets/icons/avatars/avatar-1.svg",
          reviewText:
            "Date night pics - we usually try to make reservations here ahead of time but can usually get a table on a mid weeknight early on in the evening. Love the seasonal specials here and all the sushi. Negitoro rolls are a staple in our rotation and their nigiri specials. I also really love that this restaurant, while very small with limited space, is kid friendly. I have dined here with 1 and then both of my kids and the staff are very kind and welcoming. They have high chairs. Food comes out quickly and the tables turn over relatively quickly with a few exceptions for tables that are drinking with more nibbles. Haven't had a bad meal here but the prices are definitely on the high side. Often wonder how the college students afford to eat here because I definitely didn't have the budget when I was in undergrad.",
          rating: 4.5,
          date: "3 days ago",
        },
        {
          name: "Lisa Jackson",
          id: "ZP37646739299399",
          avatar: "./assets/icons/avatars/avatar-1.svg",
          reviewText:
            "Date night pics - we usually try to make reservations here ahead of time but can usually get a table on a mid weeknight early on in the evening. Love the seasonal specials here and all the sushi. Negitoro rolls are a staple in our rotation and their nigiri specials. I also really love that this restaurant, while very small with limited space, is kid friendly. I have dined here with 1 and then both of my kids and the staff are very kind and welcoming. They have high chairs. Food comes out quickly and the tables turn over relatively quickly with a few exceptions for tables that are drinking with more nibbles. Haven't had a bad meal here but the prices are definitely on the high side. Often wonder how the college students afford to eat here because I definitely didn't have the budget when I was in undergrad.",
          rating: 4.5,
          date: "3 days ago",
        },
        {
          name: "Lisa Jackson",
          id: "ZP37646739299399",
          avatar: "./assets/icons/avatars/avatar-1.svg",
          reviewText:
            "Date night pics - we usually try to make reservations here ahead of time but can usually get a table on a mid weeknight early on in the evening. Love the seasonal specials here and all the sushi. Negitoro rolls are a staple in our rotation and their nigiri specials. I also really love that this restaurant, while very small with limited space, is kid friendly. I have dined here with 1 and then both of my kids and the staff are very kind and welcoming. They have high chairs. Food comes out quickly and the tables turn over relatively quickly with a few exceptions for tables that are drinking with more nibbles. Haven't had a bad meal here but the prices are definitely on the high side. Often wonder how the college students afford to eat here because I definitely didn't have the budget when I was in undergrad.",
          rating: 4.5,
          date: "3 days ago",
        },
        {
          name: "Lisa Jackson",
          id: "ZP37646739299399",
          avatar: "./assets/icons/avatars/avatar-1.svg",
          reviewText:
            "Date night pics - we usually try to make reservations here ahead of time but can usually get a table on a mid weeknight early on in the evening. Love the seasonal specials here and all the sushi. Negitoro rolls are a staple in our rotation and their nigiri specials. I also really love that this restaurant, while very small with limited space, is kid friendly. I have dined here with 1 and then both of my kids and the staff are very kind and welcoming. They have high chairs. Food comes out quickly and the tables turn over relatively quickly with a few exceptions for tables that are drinking with more nibbles. Haven't had a bad meal here but the prices are definitely on the high side. Often wonder how the college students afford to eat here because I definitely didn't have the budget when I was in undergrad.",
          rating: 4.5,
          date: "3 days ago",
        },
      ],
    },
  },
  {
    id: "ZP3756783223456",
    name: "Carey Winston",
    distance: "2km away",
    phone: "+1 894 747 44",
    email: "careywinston@gmail.com",
    avatar: "./assets/icons/avatars/avatar-4.svg",
    totalEarnings: "$73,000.84",
    completedOrders: 154,
    averageDeliveriesPerDay: 28,
    averageDeliveries: 32,
    otherDeliveries: 28,
    lastDelivery: "1 hour ago",
    blockStatus: true,
    status: "Available",
    pinned: false,
    reviews: {
      totalReviews: 38,
      averageRating: 4.5,
      reviewsList: [
        {
          name: "Lisa Jackson",
          id: "ZP37646739299399",
          avatar: "./assets/icons/avatars/avatar-1.svg",
          reviewText:
            "Date night pics - we usually try to make reservations here ahead of time but can usually get a table on a mid weeknight early on in the evening. Love the seasonal specials here and all the sushi. Negitoro rolls are a staple in our rotation and their nigiri specials. I also really love that this restaurant, while very small with limited space, is kid friendly. I have dined here with 1 and then both of my kids and the staff are very kind and welcoming. They have high chairs. Food comes out quickly and the tables turn over relatively quickly with a few exceptions for tables that are drinking with more nibbles. Haven't had a bad meal here but the prices are definitely on the high side. Often wonder how the college students afford to eat here because I definitely didn't have the budget when I was in undergrad.",
          rating: 4.5,
          date: "3 days ago",
        },
        {
          name: "Lisa Jackson",
          id: "ZP37646739299399",
          avatar: "./assets/icons/avatars/avatar-1.svg",
          reviewText:
            "Date night pics - we usually try to make reservations here ahead of time but can usually get a table on a mid weeknight early on in the evening. Love the seasonal specials here and all the sushi. Negitoro rolls are a staple in our rotation and their nigiri specials. I also really love that this restaurant, while very small with limited space, is kid friendly. I have dined here with 1 and then both of my kids and the staff are very kind and welcoming. They have high chairs. Food comes out quickly and the tables turn over relatively quickly with a few exceptions for tables that are drinking with more nibbles. Haven't had a bad meal here but the prices are definitely on the high side. Often wonder how the college students afford to eat here because I definitely didn't have the budget when I was in undergrad.",
          rating: 4.5,
          date: "3 days ago",
        },
        {
          name: "Lisa Jackson",
          id: "ZP37646739299399",
          avatar: "./assets/icons/avatars/avatar-1.svg",
          reviewText:
            "Date night pics - we usually try to make reservations here ahead of time but can usually get a table on a mid weeknight early on in the evening. Love the seasonal specials here and all the sushi. Negitoro rolls are a staple in our rotation and their nigiri specials. I also really love that this restaurant, while very small with limited space, is kid friendly. I have dined here with 1 and then both of my kids and the staff are very kind and welcoming. They have high chairs. Food comes out quickly and the tables turn over relatively quickly with a few exceptions for tables that are drinking with more nibbles. Haven't had a bad meal here but the prices are definitely on the high side. Often wonder how the college students afford to eat here because I definitely didn't have the budget when I was in undergrad.",
          rating: 4.5,
          date: "3 days ago",
        },
        {
          name: "Lisa Jackson",
          id: "ZP37646739299399",
          avatar: "./assets/icons/avatars/avatar-1.svg",
          reviewText:
            "Date night pics - we usually try to make reservations here ahead of time but can usually get a table on a mid weeknight early on in the evening. Love the seasonal specials here and all the sushi. Negitoro rolls are a staple in our rotation and their nigiri specials. I also really love that this restaurant, while very small with limited space, is kid friendly. I have dined here with 1 and then both of my kids and the staff are very kind and welcoming. They have high chairs. Food comes out quickly and the tables turn over relatively quickly with a few exceptions for tables that are drinking with more nibbles. Haven't had a bad meal here but the prices are definitely on the high side. Often wonder how the college students afford to eat here because I definitely didn't have the budget when I was in undergrad.",
          rating: 4.5,
          date: "3 days ago",
        },
      ],
    },
  },
];
const deliveryPartnerTable = deliveryPartnerPage.querySelector("table tbody");

const freelancePartnerTable = deliveryPartnerPage.querySelector(
  "#freelance-table tbody"
);
const inhousePartnerTable = deliveryPartnerPage.querySelector(
  "#inhouse-table tbody"
);

// Search feature
const searchInput = document.querySelector("#main-search > input");

searchInput.addEventListener("input", (event) => {
  const searchValue = event.target.value.toLowerCase();
  if (deliveryPage == "freelance") {
    const tableRows = freelancePartnerTable.querySelectorAll("tr");
    tableRows.forEach((row) => {
      const nameCell = row.querySelector(
        "td:nth-child(3) > div > span:nth-child(1)"
      );
      const cellText = nameCell.textContent.toLowerCase();
      if (cellText.includes(searchValue)) {
        row.style.display = "flex";
      } else {
        row.style.display = "none";
      }
    });
  } else {
    const tableRows = inhousePartnerTable.querySelectorAll("tr");

    tableRows.forEach((row) => {
      const nameCell = row.querySelector(
        "td:nth-child(3) > div > span:nth-child(1)"
      );
      const cellText = nameCell.textContent.toLowerCase();
      if (cellText.includes(searchValue)) {
        row.style.display = "flex"; // Show row
      } else {
        row.style.display = "none"; // Hide row
      }
    });
  }
});

// Dropdown Filter
const ratingDropdownItems = deliveryPartnerPage.querySelectorAll(
  ".ratings-filter .dropdown ul li, #delivery > header .nested-dropdown.rating .dropdown ul li"
);

ratingDropdownItems.forEach((item) => {
  item.addEventListener("click", () => {
    const selectedValue = item.getAttribute("data-value");

    if (deliveryPage == "freelance") {
      const tableRows = freelancePartnerTable.querySelectorAll("tr");
      tableRows.forEach((row) => {
        const ratingCell = row.querySelector("td:nth-child(5) > span");
        const cellText = ratingCell.textContent.toLowerCase();
        if (cellText == selectedValue) {
          row.style.display = "flex";
        } else {
          row.style.display = "none";
        }
      });
    } else {
      const tableRows = inhousePartnerTable.querySelectorAll("tr");
      tableRows.forEach((row) => {
        const ratingCell = row.querySelector("td:nth-child(5) > span");
        const cellText = ratingCell.textContent.toLowerCase();
        if (cellText == selectedValue) {
          row.style.display = "flex";
        } else {
          row.style.display = "none";
        }
      });
    }
  });
});

const statusDropdownItems = deliveryPartnerPage.querySelectorAll(
  ".status-filter .dropdown ul li, #delivery > header .nested-dropdown.status .dropdown ul li"
);

statusDropdownItems.forEach((item) => {
  item.addEventListener("click", () => {
    const selectedValue = item.getAttribute("data-value");

    if (deliveryPage == "freelance") {
      const tableRows = freelancePartnerTable.querySelectorAll("tr");
      tableRows.forEach((row) => {
        if (selectedValue === "all") {
          tableRows.forEach((row) => {
            row.style.display = "flex";
          });
        } else if (selectedValue == "blocked") {
          const availabilityCell = row.querySelector("td:nth-child(11) span");
          const cellText = availabilityCell.textContent.toLowerCase();
          if (cellText == selectedValue) {
            row.style.display = "flex";
          } else {
            row.style.display = "none";
          }
        } else if (selectedValue == "available") {
          const availabilityCell = row.querySelector("td:nth-child(11) span");
          const cellText = availabilityCell.textContent.toLowerCase();
          if (cellText == selectedValue) {
            row.style.display = "flex";
          } else {
            row.style.display = "none";
          }
        } else if (selectedValue == "unavailable") {
          const availabilityCell = row.querySelector("td:nth-child(11) span");
          const cellText = availabilityCell.textContent.toLowerCase();
          if (cellText == selectedValue) {
            row.style.display = "flex";
          } else {
            row.style.display = "none";
          }
        }
      });
    } else {
      const tableRows = inhousePartnerTable.querySelectorAll("tr");
      tableRows.forEach((row) => {
        if (selectedValue === "all") {
          tableRows.forEach((row) => {
            row.style.display = "flex";
          });
        } else if (selectedValue == "blocked") {
          const availabilityCell = row.querySelector("td:nth-child(11) span");
          const cellText = availabilityCell.textContent.toLowerCase();
          if (cellText == selectedValue) {
            row.style.display = "flex";
          } else {
            row.style.display = "none";
          }
        } else if (selectedValue == "available") {
          const availabilityCell = row.querySelector("td:nth-child(11) span");
          const cellText = availabilityCell.textContent.toLowerCase();
          if (cellText == selectedValue) {
            row.style.display = "flex";
          } else {
            row.style.display = "none";
          }
        } else if (selectedValue == "unavailable") {
          const availabilityCell = row.querySelector("td:nth-child(11) span");
          const cellText = availabilityCell.textContent.toLowerCase();
          if (cellText == selectedValue) {
            row.style.display = "flex";
          } else {
            row.style.display = "none";
          }
        }
      });
    }
  });
});

const tableDropdownItems = deliveryPartnerPage.querySelectorAll(
  ".delivery-header .select-dropdown .dropdown ul li"
);

tableDropdownItems.forEach((item) => {
  item.addEventListener("click", () => {
    const selectedValue = item.getAttribute("data-value");
    let filteredPartners;

    if (selectedValue === "highest-delivery") {
      if (deliveryPage == "freelance") {
        const tableRows = freelancePartnerTable.querySelectorAll("tr");
        tableRows.forEach((row) => {
          const otherDeliveriesCell = row.querySelector("td:nth-child(8)");
          const cellText = otherDeliveriesCell.textContent.toLowerCase();
          if (cellText > 20) {
            row.style.display = "flex";
          } else {
            row.style.display = "none";
          }
        });
      } else {
        const tableRows = inhousePartnerTable.querySelectorAll("tr");
        tableRows.forEach((row) => {
          const otherDeliveriesCell = row.querySelector("td:nth-child(8)");
          const cellText = otherDeliveriesCell.textContent.toLowerCase();
          if (cellText > 20) {
            row.style.display = "flex";
          } else {
            row.style.display = "none";
          }
        });
      }
    } else if (selectedValue === "highest-average-delivery") {
      if (deliveryPage == "freelance") {
        const tableRows = freelancePartnerTable.querySelectorAll("tr");
        tableRows.forEach((row) => {
          const averageDeliveriesCell = row.querySelector("td:nth-child(4)");
          const cellText = averageDeliveriesCell.textContent.toLowerCase();
          if (cellText > 20) {
            row.style.display = "flex";
          } else {
            row.style.display = "none";
          }
        });
      } else {
        const tableRows = inhousePartnerTable.querySelectorAll("tr");
        tableRows.forEach((row) => {
          const averageDeliveriesCell = row.querySelector("td:nth-child(4)");
          const cellText = averageDeliveriesCell.textContent.toLowerCase();
          if (cellText > 20) {
            row.style.display = "flex";
          } else {
            row.style.display = "none";
          }
        });
      }
    } else if (selectedValue === "nearby") {
      filteredPartners = deliveryPartnersData.filter((partner) => {
        const distanceValue = parseFloat(
          partner.distance.replace("km away", "").trim()
        );
        return distanceValue <= 2;
      });
      if (deliveryPage == "freelance") {
        const tableRows = freelancePartnerTable.querySelectorAll("tr");
        tableRows.forEach((row) => {
          const distanceCell = row.querySelector("td:nth-child(10)");
          const cellText = distanceCell.textContent.toLowerCase();
          const distanceValue = parseFloat(
            cellText.replace("km away", "").trim()
          );
          if (distanceValue <= 20) {
            row.style.display = "flex";
          } else {
            row.style.display = "none";
          }
        });
      } else {
        const tableRows = inhousePartnerTable.querySelectorAll("tr");
        tableRows.forEach((row) => {
          const distanceCell = row.querySelector("td:nth-child(10)");
          const cellText = distanceCell.textContent.toLowerCase();
          const distanceValue = parseFloat(
            cellText.replace("km away", "").trim()
          );
          if (distanceValue <= 20) {
            row.style.display = "flex";
          } else {
            row.style.display = "none";
          }
        });
      }
    }
  });
});

const clearFilterButton = deliveryPartnerPage.querySelector(
  ".delivery-header .dropdown-heading .clear"
);

clearFilterButton.addEventListener("click", () => {
  if (deliveryPage == "freelance") {
    const tableRows = freelancePartnerTable.querySelectorAll("tr");

    tableRows.forEach((row) => {
      const nameCell = row.querySelector(
        "td:nth-child(3) > div > span:nth-child(1)"
      );
      const cellText = nameCell.textContent.toLowerCase();
      if (cellText.includes(searchValue)) {
        row.style.display = "flex"; // Show row
      } else {
        row.style.display = "none"; // Hide row
      }
    });
  } else {
  }
  populateDeliveryTable(deliveryPartnersData);

  deliveryPartnerPage
    .querySelector(".delivery-header .select-dropdown")
    .classList.remove("open");

  deliveryPartnerPage.querySelector(
    ".delivery-header .select-dropdown .dropdown-button span"
  ).textContent = "Sort By";
});

// Add Delivery Partner
const addDeliveryPartnerButton = deliveryPartnerPage.querySelector(
  "#delivery > header .add-partner-btn"
);
addDeliveryPartnerButton.addEventListener("click", () => {
  const modal = existingModal.cloneNode(true);
  modal.id = "add-partner-modal";
  modal.classList.add("lined-modal");

  modal.innerHTML = `
        <div class="modal-heading">
          <p>
            <svg width="18" height="24" viewBox="0 0 18 24" fill="none" xmlns="http://www.w3.org/2000/svg">
              <path d="M16.5 3.37494H12.9675C12.722 2.51203 12.2018 1.7527 11.4858 1.21205C10.7699 0.6714 9.89716 0.378906 9 0.378906C8.10284 0.378906 7.23014 0.6714 6.51418 1.21205C5.79822 1.7527 5.27804 2.51203 5.0325 3.37494H1.5C1.20163 3.37494 0.915483 3.49346 0.704505 3.70444C0.493526 3.91542 0.375 4.20157 0.375 4.49994C0.375 4.79831 0.493526 5.08446 0.704505 5.29543C0.915483 5.50641 1.20163 5.62494 1.5 5.62494H5.0325C5.19587 6.20308 5.48387 6.73843 5.87625 7.19338C4.89 7.74775 4.06906 8.5546 3.49769 9.5311C2.92632 10.5076 2.62512 11.6186 2.625 12.7499V18.7499C2.625 19.2472 2.82254 19.7241 3.17417 20.0758C3.52581 20.4274 4.00272 20.6249 4.5 20.6249H6C6 21.4206 6.31607 22.1837 6.87868 22.7463C7.44129 23.3089 8.20435 23.6249 9 23.6249C9.79565 23.6249 10.5587 23.3089 11.1213 22.7463C11.6839 22.1837 12 21.4206 12 20.6249H13.5C13.9973 20.6249 14.4742 20.4274 14.8258 20.0758C15.1775 19.7241 15.375 19.2472 15.375 18.7499V12.7499C15.3745 11.6182 15.0727 10.507 14.5007 9.53044C13.9286 8.55391 13.1069 7.74727 12.12 7.19338C12.5124 6.73843 12.8004 6.20308 12.9637 5.62494H16.5C16.7984 5.62494 17.0845 5.50641 17.2955 5.29543C17.5065 5.08446 17.625 4.79831 17.625 4.49994C17.625 4.20157 17.5065 3.91542 17.2955 3.70444C17.0845 3.49346 16.7984 3.37494 16.5 3.37494ZM9.75 20.6249C9.75 20.8239 9.67098 21.0146 9.53033 21.1553C9.38968 21.2959 9.19891 21.3749 9 21.3749C8.80109 21.3749 8.61032 21.2959 8.46967 21.1553C8.32902 21.0146 8.25 20.8239 8.25 20.6249V15.3749C8.25 15.176 8.32902 14.9853 8.46967 14.8446C8.61032 14.704 8.80109 14.6249 9 14.6249C9.19891 14.6249 9.38968 14.704 9.53033 14.8446C9.67098 14.9853 9.75 15.176 9.75 15.3749V20.6249ZM13.125 18.3749H12V15.3749C12 14.5793 11.6839 13.8162 11.1213 13.2536C10.5587 12.691 9.79565 12.3749 9 12.3749C8.20435 12.3749 7.44129 12.691 6.87868 13.2536C6.31607 13.8162 6 14.5793 6 15.3749V18.3749H4.875V12.7499C4.875 11.6559 5.3096 10.6067 6.08318 9.83312C6.85677 9.05954 7.90598 8.62494 9 8.62494C10.094 8.62494 11.1432 9.05954 11.9168 9.83312C12.6904 10.6067 13.125 11.6559 13.125 12.7499V18.3749ZM7.125 4.49994C7.125 4.1291 7.23497 3.76659 7.44099 3.45824C7.64702 3.1499 7.93986 2.90958 8.28247 2.76766C8.62508 2.62575 9.00208 2.58862 9.3658 2.66097C9.72951 2.73331 10.0636 2.91189 10.3258 3.17411C10.588 3.43634 10.7666 3.77043 10.839 4.13414C10.9113 4.49786 10.8742 4.87486 10.7323 5.21747C10.5904 5.56008 10.35 5.85292 10.0417 6.05894C9.73335 6.26497 9.37084 6.37494 9 6.37494C8.50272 6.37494 8.02581 6.17739 7.67417 5.82576C7.32254 5.47413 7.125 4.99722 7.125 4.49994Z" fill="#2D2C2C"/>
            </svg>
            <span>Add Delivery Staff</span>
          </p>
          <button type="button" class="close-button">
            <img
              src="./assets/icons/close.svg"
              alt="close icon"
              class="close-icon"
            />
          </button>
        </div>
        <div class="modal-body">
          <div class="floating-controls">
            <input
              type="email"
              id="partner-email"
              name="partner-email"
              placeholder="Enter email here"
            />
            <label for="partner-email">Email</label>
          </div>
          <button class="primary-button" id="add-partner">
            <span>Add</span>
            <svg width="21" height="20" viewBox="0 0 21 20" fill="none" xmlns="http://www.w3.org/2000/svg">
              <path d="M10.5 0.25C8.57164 0.25 6.68657 0.821828 5.08319 1.89317C3.47982 2.96451 2.23013 4.48726 1.49218 6.26884C0.754225 8.05042 0.561142 10.0108 0.937348 11.9021C1.31355 13.7934 2.24215 15.5307 3.60571 16.8943C4.96928 18.2579 6.70656 19.1865 8.59787 19.5627C10.4892 19.9389 12.4496 19.7458 14.2312 19.0078C16.0127 18.2699 17.5355 17.0202 18.6068 15.4168C19.6782 13.8134 20.25 11.9284 20.25 10C20.2468 7.41513 19.2185 4.93705 17.3907 3.10927C15.563 1.28149 13.0849 0.253225 10.5 0.25ZM14.25 10.75H11.25V13.75C11.25 13.9489 11.171 14.1397 11.0303 14.2803C10.8897 14.421 10.6989 14.5 10.5 14.5C10.3011 14.5 10.1103 14.421 9.96967 14.2803C9.82902 14.1397 9.75 13.9489 9.75 13.75V10.75H6.75C6.55109 10.75 6.36033 10.671 6.21967 10.5303C6.07902 10.3897 6 10.1989 6 10C6 9.80109 6.07902 9.61032 6.21967 9.46967C6.36033 9.32902 6.55109 9.25 6.75 9.25H9.75V6.25C9.75 6.05109 9.82902 5.86032 9.96967 5.71967C10.1103 5.57902 10.3011 5.5 10.5 5.5C10.6989 5.5 10.8897 5.57902 11.0303 5.71967C11.171 5.86032 11.25 6.05109 11.25 6.25V9.25H14.25C14.4489 9.25 14.6397 9.32902 14.7803 9.46967C14.921 9.61032 15 9.80109 15 10C15 10.1989 14.921 10.3897 14.7803 10.5303C14.6397 10.671 14.4489 10.75 14.25 10.75Z" fill="white"/>
            </svg>
          </button>
        </div>
      `;

  main.appendChild(modal);
  modal.showModal();

  const addPartnerButton = modal.querySelector("#add-partner");
  addPartnerButton.addEventListener("click", async () => {
    const partnerEmailInput = modal
      .querySelector("#partner-email")
      .value.trim();

    if (partnerEmailInput) {
      if (validateEmail(partnerEmailInput)) {
        const partner = await getFiltered("delivery-partners", {
          email: partnerEmailInput,
        });
        console.log(partner);
        let item = {
          id: "",
          email: partnerEmailInput,
        };
        if (!partner || partner.length == 0) {
          alert("Partner does not exists");
        } else {
          alert("Partner already exists");
          item.id = partner.id;
        }
        restaurantData.deliveryPartners.push(item);
        let updatedData = {
          deliveryPartners: restaurantData.deliveryPartners,
        };
        await update("restaurants", restaurantID, updatedData);
        populateDeliveryPartnerPage();
        modal.close();
        modal.remove();
      } else {
        console.log("Invalid email. Please enter a valid email address.");
      }
    } else {
      console.log("undone");
    }
  });

  const closeButton = modal.querySelector(".close-button");
  closeButton.addEventListener("click", () => {
    modal.close();
    modal.remove();
  });
});
const tableDropdown = deliveryPartnerPage.querySelector(
  "table > thead > tr > th:nth-child(12)"
);
tableDropdown.addEventListener("click", () => {
  console.log("clicked");
});
