const secondaryLogin = [
  {
    name: "Google",
    title: "google-signin",
    img: "/assets/restaurant/images/svg/google.svg",
    link: "https://www.google.com",
    alt: "google logo icon",
  },
  {
    name: "Facebook",
    title: "facebook-signin",
    img: "/assets/restaurant/images/svg/facebook.svg",
    link: "https://www.facebook.com",
    alt: "facebook logo icon",
  },
];

const secondaryBtn = () => {
  secondaryLogin.forEach((btn) => {
    const link = document.createElement("a");
    link.id = btn.title;
    link.href = btn.link;
    link.classList.add("flex-center");

    const container = document.createElement("div");
    container.classList.add("flex-sm");

    const logo = new Image();
    logo.src = btn.img;
    container.appendChild(logo);
    logo.style.width = "20%";

    const text = document.createElement("p");
    text.textContent = `Continue with ${btn.name}`;
    text.style.whiteSpace = "nowrap";
    text.classList.add("misc-dark-text");
    container.appendChild(text);

    link.appendChild(container);

    document.querySelector(".secondary-signin").appendChild(link);
  });
};

// logged out context....
const isLoggedOut = () => {
  const text = document.createElement("p");
  text.classList.add("bolder");
  text.textContent = "Welcome to Zoop 👋🏾";

  document.querySelector(".salutation").appendChild(text);
};

// logged in context.....
const isLoggedIn = () => {
  const user = { firstname: "James", lastname: "Jones" };

  const text = document.createElement("p");
  text.classList.add("bolder");
  text.textContent = `Welcome back, ${user.firstname}!`;

  document.querySelector(".salutation").appendChild(text);

  const link = document.createElement("a");
  link.id = "user-link";
  link.href = "./pages/home.html";
  link.classList.add("flex-between");

  const pictureDiv = document.createElement('div');
  pictureDiv.className = "picture-frame flex-center";
  const profilePicture = new Image();
  profilePicture.src = "/assets/restaurant/images/avatars/males/Property 1=James.png";
  pictureDiv.appendChild(profilePicture);
  link.appendChild(pictureDiv);
  profilePicture.style.borderRadius = "var(--br-auto)";

  const container = document.createElement("div");
  container.classList.add("flex-sm");

  const userID = document.createElement("div");
  userID.classList.add("flex-column-right");

  const userName = document.createElement("p");
  userName.classList.add("bolder");
  userName.textContent = user.firstname + " " + user.lastname;
  userName.style.whiteSpace = "nowrap";
  userID.appendChild(userName);

  const status = document.createElement("p");
  status.classList.add("misc-text");
  status.textContent = "Logged In";
  userID.appendChild(status);
  container.appendChild(userID);

  const icon = new Image();
  icon.src = "/assets/restaurant/images/svg/right-arrow-head.svg";

  container.appendChild(icon);

  link.appendChild(container);

  const or = document.createElement("p");
  or.textContent = "Or";
  or.style.color = "var(--tint-text-clr)";
  or.style.textAlign = "center";

  document.querySelector(".user-log").appendChild(link);
  document.querySelector(".user-log").appendChild(or);
};

const signin = () => {
    const wrapper = document.querySelector('.wrapper');
    wrapper.classList.contains('is-logged-in') ? isLoggedIn() : isLoggedOut();
}

window.addEventListener("load", () => {
  secondaryBtn();
  signin();
});
