const header = document.querySelector(".header");
header.classList.add("flex-between");

const overview = (next, nextLink) => {
  const overviewWrapper = document.createElement("div");
  overviewWrapper.className = "flex";
  const previousPage = document.createElement("a");
  previousPage.setAttribute("href", "../pages/home.html");
  previousPage.textContent = "Home";
  previousPage.className = "paragraph-light-text";
  overviewWrapper.appendChild(previousPage);

  const imgContainer = document.createElement("div");
  imgContainer.className = "flex-center";
  imgContainer.style.height = "15px";
  imgContainer.style.width = "15px";

  const img = new Image();
  img.src = "/assets/restaurant/images/svg/right-arrow-tint.svg";
  imgContainer.appendChild(img);
  overviewWrapper.appendChild(imgContainer);

  const nextPage = document.createElement("a");
  nextPage.setAttribute("href", nextLink);
  nextPage.className = "paragraph-light-text";
  nextPage.textContent = next;
  overviewWrapper.appendChild(nextPage);

  header.appendChild(overviewWrapper);
};

const renderOverview = () => {
  let wrapper = document.querySelector(".wrapper");

  if (wrapper.classList.contains("home")) {
    // render overview link
    overview("Overview", "#");
  } else if (wrapper.classList.contains("orders")) {
    // render orders link
    overview("Orders", "../pages/order.html");
  } else if (wrapper.classList.contains("deliveries")) {
    // render deliveries link
    overview("Deliveries", "../pages/deliveries.html");
  } else if (wrapper.classList.contains("dishes")) {
    // render dishes link
    overview("Dishes & Menu", "../pages/dishes.html");
  }
};

const searchBar = () => {
  const form = document.createElement("form");
  form.className = "search-form flex-between";

  const input = document.createElement("input");
  input.className = "search-bar bold";
  input.placeholder = "Search orders, riders etc";

  const button = document.createElement("button");
  button.className = "search-btn flex-center icon-square";
  button.setAttribute('type','submit');

  const submitImg = new Image();
  submitImg.src = "/assets/restaurant/images/svg/search.svg";
  button.appendChild(submitImg);

  form.appendChild(input);
  form.appendChild(button);

  header.appendChild(form);
};

const profile = () => {
  // profile wrapper
  const profileWrapper = document.createElement('div');
  profileWrapper.className = "flex-between profile-wrapper";
  header.appendChild(profileWrapper);

  // notification
  const notificationWrapper = document.createElement('div');
  notificationWrapper.className = "note-wrapper flex-center btn";

  const notificationDiv = document.createElement('div');
  notificationDiv.className = "flex-center icon-square";
  const notificationImg = new Image();
  notificationImg.src = "/assets/restaurant/images/svg/bell.svg";
  notificationDiv.appendChild(notificationImg);
  notificationWrapper.appendChild(notificationDiv);
  notificationWrapper.addEventListener('click', () => { notificationCard(notificationWrapper)}
  );

  profileWrapper.appendChild(notificationWrapper);


  // profile status 
  const statusWrapper = document.createElement('div');
  statusWrapper.className = "flex-sm status-wrapper btn";

  const statusText = document.createElement('p');
  statusText.className = "paragraph-text bold status-text";
  statusText.textContent = 'Open';
  statusWrapper.appendChild(statusText);

  profileWrapper.appendChild(statusWrapper);

  const statusIndicator = document.createElement('div');
  statusIndicator.className = "status-indicator";
  const statusBall = document.createElement('div');
  statusBall.className = "status-ball";

  statusIndicator.appendChild(statusBall);
  statusWrapper.appendChild(statusIndicator);

  // user profile 
  const userWrapper = document.createElement('div');
  userWrapper.className = "user-wrapper flex-sm btn"

  profileWrapper.appendChild(userWrapper);

  const userDiv = document.createElement('div');
  userDiv.className ="user-img flex-center";
  const userImg = new Image();
  userImg.src = "/assets/restaurant/images/avatars/males/Property 1=James.png"
  userImg.style.borderRadius = "var(--br-auto)";
  userDiv.appendChild(userImg);
  userWrapper.appendChild(userDiv)

  const userIndicator = document.createElement('div');
  userIndicator.className = "user-indicator flex-center icon-square drop-down";
  const indicator = new Image();
  indicator.src = "/assets/restaurant/images/svg/dropdown-arrow.svg"
  userIndicator.appendChild(indicator);
  userWrapper.appendChild(userIndicator);

  userWrapper.addEventListener('click', () => {
    profileCard(userWrapper);
  })
}

// Notification array 
const messagesArr = [ {
  id: "1",
  oid: "New Order ZP 73893994044",
  time: "2 Mins Ago",
  price: "$27.99",
}, {
  id: "2",
  oid: "New Order ZP 73893994044",
  time: "2 Mins Ago",
  price: "$27.99",
}, {
  id: "3",
  oid: "New Order ZP 73893994044",
  time: "2 Mins Ago",
  price: "$27.99",
}, {
  id: "4",
  oid: "New Order ZP 73893994044",
  time: "2 Mins Ago",
  price: "$27.99",
}, {
  id: "5",
  oid: "New Order ZP 73893994044",
  time: "2 Mins Ago",
  price: "$27.99",
},]

localStorage.setItem("Orders", JSON.stringify(messagesArr));


// Notification banner 
const notificationAlert = () => {
  let parent = document.querySelector('.note-wrapper');
  let array =  JSON.parse(localStorage.getItem("Orders"))

  const banner = document.createElement('div');
  banner.className = "banner flex-center";
  const messageIndex = document.createElement('p');
  messageIndex.className = "misc-light-text";
  if (array) {
    array.length < 9 ? messageIndex.textContent = array.length : messageIndex.textContent = "9+"
  }
  banner.appendChild(messageIndex);
  parent.appendChild(banner);
}

// Render notifications 
const notificationCard = (parent) => {
  const notesArr = JSON.parse(localStorage.getItem("Orders"));
 
  const noteCard = document.createElement('div');
  noteCard.className = "notification-card flex-column";

  const cardHeader = document.createElement('div');
  cardHeader.className = "flex card-header drop-down-header";
  noteCard.appendChild(cardHeader);

  const headerText = document.createElement('p');
  headerText.className = "misc-text";
  headerText.textContent = "Notification";
  cardHeader.appendChild(headerText);

  const noteList = document.createElement('ul');
  noteList.className = "scroll-down-list";
  noteCard.appendChild(noteList);
  
  if(parent.childElementCount < 3) {
    parent.appendChild(noteCard);
  } else {
    removeNoteCard();
  }

  notesArr.map((item) => {
    const noteItem = document.createElement('li') ;
    noteItem.className = "note-item flex-between";

    const noteWrapper = document.createElement("div");
    noteWrapper.className = "flex-sm";
    noteItem.appendChild(noteWrapper);


    const imgDiv = document.createElement('div');
    imgDiv.className = "flex-center"
    const icon = new Image();
    icon.src = "/assets/restaurant/images/svg/bell-yellow.svg";
    imgDiv.appendChild(icon);
    noteWrapper.appendChild(imgDiv);

    const noteOrderDiv = document.createElement('div');
    noteOrderDiv.className = "flex-column";
    noteWrapper.appendChild(noteOrderDiv);

    const noteOrder = document.createElement('p');
    noteOrder.className = "paragraph-text bold";
    noteOrder.textContent = item.oid;
    noteOrderDiv.appendChild(noteOrder);

    const notePrice = document.createElement('p');
    notePrice.className = "paragraph-accent-text bold";
    notePrice.textContent = item.price;
    noteOrderDiv.appendChild(notePrice);

    const noteTime = document.createElement('p');
    noteTime.className = "misc-text";
    noteTime.textContent = item.time;
    noteItem.appendChild(noteTime);

    noteList.appendChild(noteItem);
  })
}

const removeNoteCard = () => {
  document.querySelector(".notification-card").remove();
}

// Render profile card 
const profileCard = (parent) => {

  const profileCardArr = [ {
    img: "/assets/restaurant/images/svg/user-stick.svg",
    text: "Account setting",
    indicator: "/assets/restaurant/images/svg/user-arrow.svg"
  },{
    img: "/assets/restaurant/images/svg/block-tint.svg",
    text: "Visit main site",
    indicator: "/assets/restaurant/images/svg/upload-green.svg"
  },]
  

    const userName = "James Jameson";
    const userCard = document.createElement('div');
    userCard.className = "user-card";
    parent.appendChild(userCard);

    const userCardHeader = document.createElement('div');
    userCardHeader.className = "user-card-header flex-sm drop-down-header";
    userCard.appendChild(userCardHeader);

    const imgDiv = document.createElement('div');
    imgDiv.className = "flex-center user-img";
    const userImage = new Image();
    userImage.src = "/assets/restaurant/images/avatars/males/Property 1=James.png"
    imgDiv.appendChild(userImage);
    userCardHeader.appendChild(imgDiv);

    const userText = document.createElement("p");
    userText.className = "paragraph-text bold";
    userText.textContent = userName;
    userCardHeader.appendChild(userText);

    const userContainer = document.createElement('div');
    userContainer.className = "drop-down-list"
    userCard.appendChild(userContainer);


    if(parent.childElementCount < 4) {
      parent.appendChild(userCard);
    } else {
      removeProfileCard();
    }

  profileCardArr.map((item) => {
    const userItem = document.createElement('a');
    userItem.className = "user-item drop-down-item flex-between";

    const wrapper = document.createElement('div')
    wrapper.className = "flex-sm";
    userItem.appendChild(wrapper);

    const div = document.createElement('div')
    div.className = "flex-center";
    const userIcon = new Image();
    userIcon.src = item.img;
    div.appendChild(userIcon);
    wrapper.appendChild(div);

    const contentText = document.createElement('p');
    contentText.className = "misc-text bold";
    contentText.textContent = item.text;
    wrapper.appendChild(contentText);

    const indicator = document.createElement('div')
    indicator.className = "user-indicator flex-center";
    const icon = new Image();
    icon.src = item.indicator;
    indicator.appendChild(icon);
    userItem.appendChild(indicator);

    userContainer.appendChild(userItem);
    
  })  

  const footer = document.createElement('div');
  footer.className = "flex-between user-card-footer drop-down-item";
  userContainer.appendChild(footer);

  const footerText = document.createElement('p');
  footerText.className = "user-footer-text misc-accent-text";
  footerText.textContent = "Logout";
  footer.appendChild(footerText);

  const footerDiv = document.createElement('div');
  footerDiv.className = "flex-center";
  const footerImg = new Image();
  footerImg.src = "/assets/restaurant/images/svg/exit.svg";
  footerDiv.appendChild(footerImg)
  footer.appendChild(footerDiv);
}

const removeProfileCard = () => {
 document.querySelector('.user-card').remove();
}

window.addEventListener('load', () => {
  renderOverview();
  searchBar();
  profile();
  if (localStorage.getItem("Orders")) {
    notificationAlert();
  }
})
