document.addEventListener("DOMContentLoaded", () => {
    //SIDEBAR
  const orderHeader = document.querySelector(".sidebar-order-header");
  const orderHeaderText = document.querySelector(".sidebar-content-text");
  const sidebarOrder = document.querySelector(".sidebar-order-type");
  const orderItems = document.querySelectorAll(".sidebar-order");
  const menuBtn = document.querySelector(".menu-btn");
  const menuList = document.querySelector(".menu-list");
  const sidebarMenu = document.querySelector(".sidebar-menu");

  /*=== display order type ===*/
  const optionsOrderTypes = () => {
    sidebarOrder.classList.toggle("active");
  };
  orderHeader.addEventListener("click", optionsOrderTypes);

  /*=== change order type ====*/
  for (let i = 0; i < orderItems.length; i++) {
    orderItems[i].addEventListener("click", () => {
      orderItems.forEach((item) => {
        item.classList.remove("active");
      });

      const orderName = document.querySelectorAll(".sidebar-order-p");

      let choiceOrder = orderName[i].textContent;

      /*=== change order ===*/
      orderHeaderText.textContent = choiceOrder;

      let currentOrder = orderHeaderText.textContent;

      if (currentOrder === orderName[i].textContent) {
        orderItems[i].classList.add("active");
      } else {
        orderItems[i].classList.remove("active");
      }

      /*=== remove order type ===*/
      optionsOrderTypes();
    });
  }

  // sidebar menu
  // display food menu on click
  menuBtn.addEventListener("click", () => {
    sidebarMenu.classList.toggle("active");
  });

  // render food  menu
  renderFoodList = () => {
    dishes.forEach((dish) => {
      menuList.innerHTML += `
    <div class="menu-item flex-between">
      <p class="menu-item-text text-normal">${dish.name}</p>
      <p class="menu-item-qty text-normal">${dish.instock}</p>
    </div>
    `;
    });
  };

  renderFoodList();

  // discount slider
  const slide = document.querySelectorAll(".discount-slides");
  const slideContent = document.querySelector(".discount-slide");
  const contentLength = slideContent.offsetWidth;
  const slider = () => {
    slide.scrollLeft += contentLength;
  };

  slider();

})