document.addEventListener("DOMContentLoaded", (event) => {
  //GLOBAL VARIABLES
  const addressContainer = document.querySelector(".header-address-container");
  const addressName = document.querySelector(".address-name");
  const addressDetails = document.querySelector(".address-details");
  const addressLinks = document.querySelectorAll(".address-options-item");
  const addressContent = document.querySelector(".header-address-content");
  const searchBar = document.querySelector(".search-bar");
  const searchInput = document.querySelector(".search-input");
  const searchForm = document.querySelector(".search-form");
  const searchLink = document.querySelector(".search-link");
  const searchBack = document.querySelector(".back-home");
  const nav = document.querySelector(".nav");
  const profileId = document.querySelector(".profile-id");
  const userProfile = document.querySelector(".user-profile");
  const profile = document.querySelector(".profile");
  const profileBack = document.querySelector(".profile-back");
  const footerContainer = document.querySelector(".footer-container");
  const curtain = document.querySelector(".curtain");
  const body = document.querySelector("#body");

  //ADDRESS SCRIPT
  /*=== render address options ===*/
  const renderAddressOptions = () => {
    addressContainer.classList.toggle("active");
    body.classList.toggle("mask");
    curtain.classList.toggle("block");
    nav.classList.toggle("hide");
  };
  addressContent.addEventListener("click", renderAddressOptions);

  /*=== remove address options ===*/
  const removeAddressOptions = () => {
    addressContainer.classList.remove("active");
    curtain.classList.remove("block");
    body.classList.toggle("mask");
    nav.classList.remove("hide");
  };

  /*=== change current address ====*/
  for (let i = 0; i < addressLinks.length; i++) {
    addressLinks[i].addEventListener("click", () => {
      addressLinks.forEach((link) => {
        link.classList.remove("active");
      });

      const orderName = document.querySelectorAll(".address-item-name");
      const addressItemDetail = document.querySelectorAll(
        ".address-item-details"
      );

      let choiceAddress = orderName[i].textContent;
      let choiceLocation = addressItemDetail[i].textContent;

      /*=== change address ===*/
      addressName.textContent = choiceAddress;
      addressDetails.textContent = choiceLocation;

      let currentAddress = addressName.textContent;
      // let currentLocation = addressDetails.textContent;

      if (currentAddress === orderName[i].textContent) {
        addressLinks[i].classList.add("active");
      } else {
        addressLinks[i].classList.remove("active");
      }
      removeAddressOptions();
    });
  }

  //SEARCH SCRIPT
  /*=== render search history ===*/
  const renderSearchHistory = () => {
    searchBar.classList.remove("hide");
    searchBar.classList.add("active");
    nav.classList.add("hide");
    body.classList.add("mask");
    curtain.classList.add("block");

  };
  searchInput.addEventListener("click", renderSearchHistory);

  /*=== ...with search link ===*/
  searchLink.addEventListener("click", renderSearchHistory);

  /*=== hide search bar on scroll ===*/
  window.addEventListener("scroll", () => {
    searchBar.classList.toggle("hide", window.scrollY > 74);
  });

  /*==== remove search history ====*/
  const removeSearchHistory = () => {
    searchBar.classList.add("hide");
    searchBar.classList.remove("active");
    nav.classList.remove("hide");
    curtain.classList.remove("block");
    // body.classList.remove("mask");
  };

  /*==== ... on submit ====*/
  searchForm.addEventListener("submit", removeSearchHistory);

  /*==== ... with search back button ====*/
  searchBack.addEventListener("click", removeSearchHistory);

  searchBar.addEventListener("mouseleave", removeSearchHistory);

  //USER PROFILE
  // display profile login
  const displayProfile = () => {
    userProfile.classList.add("active");
    curtain.classList.add("block");
    // body.classList.add("mask");
    nav.classList.add("hide");
    footerContainer.classList.add("nav-active");
  };

  /*=== ... with user profile button ===*/
  profileId.addEventListener("click", displayProfile);

  // remove profile login
  const removeProfile = () => {
    userProfile.classList.remove("active");
    curtain.classList.remove("block");
    // body.classList.remove("mask");
    nav.classList.remove("hide");
    footerContainer.classList.remove("nav-active");
  }

  profile.addEventListener("mouseleave", removeProfile);
  profileBack.addEventListener("click", removeProfile);

  // localStorage.removeItem("userFirstName");
  // localStorage.removeItem("userLastName");
  // localStorage.removeItem("userGMail");
  // localStorage.removeItem("userPssWrd");
  // localStorage.removeItem("userPhoneNumber");
  // localStorage.removeItem("FAV");

  
  console.log("DOM fully loaded and parsed");
});
