<?php

namespace App\Lib;

/**
 * Proxy class for routing methods.
 *
 * @method self get(string $pattern, $handler)
 * @method self post(string $pattern, $handler)
 * @method self put(string $pattern, $handler)
 * @method self delete(string $pattern, $handler)
 * @method self patch(string $pattern, $handler)
 * @method self any(string $pattern, $handler)
 * @method self map(array $methods, string $pattern, $handler)
 * @method self redirect(string $from, string $to, int $status = 302)
 * @method self group(string $pattern, callable $callback)
 * @method self add($middleware)
 */
class RouteCollectorProxy
{
    private $router;

    public function __construct(Router $router)
    {
        $this->router = $router;
    }

    public function __call($name, $arguments)
    {
        if (method_exists($this->router, $name)) {
            return call_user_func_array([$this->router, $name], $arguments);
        }
    }
}