<?php

namespace App\Helpers;

class DateTime
{
    private $datetime;

    public function __construct($time = 'now', $timezone = null)
    {
        $this->datetime = new \DateTime($time, new \DateTimeZone($timezone ?? date_default_timezone_get()));
    }

    public static function from($time)
    {
        if (is_numeric($time)) {
            $time = '@' . $time;
        }

        return new self($time);
    }

    public static function createFromFormat($format, $time, $timezone = null)
    {
        $datetime = DateTime::createFromFormat($format, $time, new \DateTimeZone($timezone ?? date_default_timezone_get()));
        return new self($datetime->format('c'));
    }

    public static function hasPassed($checkTime, $currentDateTime = null)
    {
        $checkDateTime = self::from($checkTime)->datetime;
        $currentDateTime = $currentDateTime ? self::from($currentDateTime)->datetime : new DateTime();

        return $checkDateTime <= $currentDateTime;
    }


    public function modifyClone($modify)
    {
        $clone = clone $this;
        $clone->datetime->modify($modify);
        return $clone;
    }

    public function format($format)
    {
        return $this->datetime->format($format);
    }

    public function toString()
    {
        return $this->datetime->format('Y-m-d H:i:s');
    }

    public static function datetime()
    {
        return (new self())->toString();
    }

    public static function time()
    {
        return (new self())->format('H:i:s');
    }
}
