<?php

declare(strict_types=1);


namespace App\Controller;

use App\Lib\Controller;
use App\Helpers\MetaTags;
use App\Models\{Restaurant};
use App\Util\{Helper, DeviceManager};

class RestaurantController extends Controller
{
    protected $sessionData;
    protected Helper $helper;
    protected DeviceManager $deviceManager;

    public function __construct()
    {
        $this->deviceManager = new DeviceManager;
        $this->sessionData = $_SESSION[SESSION['restaurant']] ?? [];
        if(!isset($this->sessionData['session_token'])){
            Helper::redirect('/restaurant/login');
        }
    }

    public function stripe()
    {
        $tag = new MetaTags;
        $tag
            ->title('Overview - ' . APP['name'])
            ->meta('author', APP['name'])
            ->meta('application-name', APP['name'])
            ->meta('theme-color', APP['theme']);

            $this->view('stripe');
    }

    public function stripe_test()
    {
        $tag = new MetaTags;
        $tag
            ->title('Overview - ' . APP['name'])
            ->meta('author', APP['name'])
            ->meta('application-name', APP['name'])
            ->meta('theme-color', APP['theme']);

            $this->view('stripe-test');
    }

    public function home()
    {
        $tag = new MetaTags;
        $tag
            ->title('Overview - ' . APP['name'])
            ->meta('author', APP['name'])
            ->meta('application-name', APP['name'])
            ->meta('theme-color', APP['theme'])
            ->meta('msapplication-TileColor', APP['theme'])
            ->meta('color-scheme', 'dark light')
            ->canonical(\URLROOT)
            ->description("")
            ->meta('keyword', "")
            // Open Graph
            ->og('type', "website")
            ->og('title', APP['name'])
            ->og('description', "")
            ->og('image', APP['logo-dark'])
            ->og('url', \URLROOT)
            // Twitter
            ->twitter('card', 'summary_large_image')
            ->twitter('title', APP['name'])
            ->twitter('url', \URLROOT)
            // Googlebot
            ->robots('follow, index, noarchive', 'robots')
            ->robots('follow, index, noarchive', 'googlebot');

        $this->view('app/home', ['meta' => $tag]);
    }

    public function sign_in()
    {
        $tag = new MetaTags;
        $tag
            ->title('Restaurant ' . APP['name'])
            ->meta('author', APP['name'])
            ->meta('application-name', APP['name'])
            ->meta('theme-color', APP['theme'])
            ->meta('msapplication-TileColor', APP['theme'])
            ->meta('color-scheme', 'dark light')
            ->canonical(\URLROOT)
            ->description("")
            ->meta('keyword', "")
            // Open Graph
            ->og('type', "website")
            ->og('title', APP['name'])
            ->og('description', "")
            ->og('image', APP['logo-dark'])
            ->og('url', \URLROOT)
            // Twitter
            ->twitter('card', 'summary_large_image')
            ->twitter('title', APP['name'])
            ->twitter('url', \URLROOT)
            // Googlebot
            ->robots('follow, index, noarchive', 'robots')
            ->robots('follow, index, noarchive', 'googlebot');

        $this->view('app/login', ['meta' => $tag]);
    }

    public function restaurant_view(string $slug)
    {
        $tag = new MetaTags;
        $tag
            ->title('Overview - ' . APP['name'])
            ->meta('author', APP['name'])
            ->meta('application-name', APP['name'])
            ->meta('theme-color', APP['theme'])
            ->meta('msapplication-TileColor', APP['theme'])
            ->meta('color-scheme', 'dark light')
            ->canonical(\URLROOT)
            ->description("")
            ->meta('keyword', "")
            // Open Graph
            ->og('type', "website")
            ->og('title', APP['name'])
            ->og('description', "")
            ->og('image', APP['logo-dark'])
            ->og('url', \URLROOT)
            // Twitter
            ->twitter('card', 'summary_large_image')
            ->twitter('title', APP['name'])
            ->twitter('url', \URLROOT)
            // Googlebot
            ->robots('follow, index, noarchive', 'robots')
            ->robots('follow, index, noarchive', 'googlebot');

        $this->view('home/static/head', ['meta' => $tag]);
        $this->view('client/restaurant-view');
        $this->view('home/static/foot', ['meta' => $tag]);
    }

}
