<?php
declare(strict_types=1);

namespace App\Controller;

use App\Lib\Controller;
use App\Models\{Restaurant, Customer, StatusUpdates, LoginHandler};
use App\Util\Helper;
use App\Helpers\FileHandler;

class StatusController
{
    protected $tokenUser;
    public function __construct()
    {
        $loginHandler = new LoginHandler;
        //$this->tokenUser = $loginHandler->getTokenData();
    }

    public function statusbar()
    {
        $postData = Helper::decodePostData();

        if(empty($postData)){
            Helper::jsonResult(['status' => false, 'message' => 'Sorry but no data was provided.']);
        }

        $device = Helper::getDevice();
        $data = \json_encode($postData);

        $status = new StatusUpdates;
        if($status->saveStatusBar($device, $data)){
            Helper::jsonResult(['status' => true, 'message' => 'Status bar updated successfully.']);
        }

        Helper::jsonResult(['status' => false, 'message' => 'Sorry but something went wrong.']);
    }

    public function createStatus()
    {
        $statusMedia = $_FILES['status_media']['name'] ?? '';
        $restaurantId = (int) $this->tokenUser['id'] ?? 0;

        if(empty($statusMedia)){
            return ['status' => false, 'message' => 'Sorry but status update image or video is required.'];
        }

        if(!empty($restaurantId)){
            return ['status' => false, 'message' => 'Sorry but you are not logged in.'];
        }

        $statusFormat = Helper::getFormat($statusMedia);
        if(!\in_array($statusFormat, ['image', 'video'])){
            return ['status' => false, 'message' => 'Sorry but this status image or video is not supported.'];
        }

        $status = new StatusUpdates;
        $result = $status->addStatus($restaurantId, 'status_media', $statusFormat);
        if($result){
            return ['status' => true, 'message' => 'Status created successfully.'];
        }

        return ['status' => false, 'message' => 'Sorry but something went wrong.'];
    }

    public function deleteStatus(int $id)
    {

    }

    public function getAll()
    {

    }
}