<?php
declare(strict_types=1);

namespace App\Controller;


use App\Lib\Controller;
use App\Util\Helper;

class LegalController extends Controller
{
    public Helper $helper;
    public function __construct()
    {
        $this->helper = new Helper;
    }

    public function render(string $target)
    {
        
        if(empty($target)) {
            @header("HTTP/1.1 401 Unauthorized");
            Helper::jsonResult(["status" => false, "message" => "Unauthorized access detected."]);
        }

        if($target === "privacy-policy") {
            $this->view('privacy-policy');
            exit;
        }

        if($target === "terms-use") {
            $this->view('terms-of-use');
            exit;
        }

        if($target === "return-policy") {
            $this->view('return-policy');
            exit;
        }

        if($target === "shipping-policy") {
            $this->view('shipping-policy');
            exit;
        }

        Helper::jsonResult(["status" => false, "message" => "Sorry, no action was provided."]);
    }
}
