<?php
declare(strict_types=1);


namespace App\Controller;

use App\Lib\Controller;
use App\Helpers\MetaTags;
use App\Util\{Helper, DeviceManager};


class HomeController extends Controller
{
    protected $sessionData;
    protected Helper $helper;
    protected DeviceManager $deviceManager;

    public function __construct()
    {
        $this->deviceManager = new DeviceManager;
        $this->sessionData = $_SESSION[SESSION['customer']] ?? [];
    }

    public function home()
    {
        $tag = new MetaTags;
        $tag
            ->title(APP['name'] . ' ' . APP['tagline'])
            ->meta('author', APP['name'])
            ->meta('application-name', APP['name'])
            ->meta('theme-color', APP['theme'])
            ->meta('msapplication-TileColor', APP['theme'])
            ->meta('color-scheme', 'dark light')
            ->canonical(\URLROOT)
            ->description("")
            ->meta('keyword', "")
            // Open Graph
            ->og('type', "website")
            ->og('title', APP['name'])
            ->og('description', "")
            ->og('image', APP['logo-dark'])
            ->og('url', \URLROOT)
            // Twitter
            ->twitter('card', 'summary_large_image')
            ->twitter('title', APP['name'])
            ->twitter('url', \URLROOT)
            // Googlebot
            ->robots('follow, index, noarchive', 'robots')
            ->robots('follow, index, noarchive', 'googlebot');

            $this->view('home/static/head', ['meta' => $tag]);
            $this->view('home/index');
            $this->view('home/static/foot');
    }

    public function sign_in()
    {
        
        $tag = new MetaTags;
        $tag
            ->title("Login | " . APP['name'])
            ->meta('author', APP['name'])
            ->meta('application-name', APP['name'])
            ->meta('theme-color', APP['theme'])
            ->meta('msapplication-TileColor', APP['theme'])
            ->meta('color-scheme', 'dark light')
            // Googlebot
            ->robots('nofollow, noindex, noarchive', 'robots')
            ->robots('nofollow, noindex, noarchive', 'googlebot');

        $this->view('home/category', ['meta' => $tag]);
    }
}